package org.simplextensions.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.simplextensions.di.DependencyInjector;
import org.simplextensions.registry.IExtensionRegistry;

public class AutowiredDialog extends Dialog {

	public AutowiredDialog(SWTApplicationWindow applicationWindow, int style) {
		this(applicationWindow.getExtensionRegistry(), applicationWindow.getShell(), style);
	}

	public AutowiredDialog(SWTApplicationWindow applicationWindow) {
		this(applicationWindow, SWT.NORMAL);
	}
	
	public AutowiredDialog(IExtensionRegistry registry, Shell shell, int style){
		super(shell, style);
		DependencyInjector.resolveDependency(registry, this);
	}

}
