package org.simplextensions.ui;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.LinkedList;
import java.util.List;

/**
 * basic implementation of {@link IStatefulUIPart}. it manages listeners and
 * allows to fire stateChange event
 * 
 * 
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-05-09 20:08:58
 */
public class StatefulUIPartAdapter implements IStatefulUIPart {

	private static final Logger log = LoggerFactory.getLogger(StatefulUIPartAdapter.class);

	private List<IStateListener> listeners = new LinkedList<IStateListener>();

	public void addStateChangeListener(IStateListener stateListener) {
		if (!listeners.contains(stateListener)) {
			listeners.add(stateListener);
		}
	}

	public void removeStateChangeListener(IStateListener stateListener) {
		listeners.remove(stateListener);
	}

	public void fireStateChanged(StateEvent stateEvent) {
		for (IStateListener listener : listeners) {
			try {
				listener.stateChanged(stateEvent);
			} catch (Exception e) {
				log.error("", e);
			}
		}
	}

}
