package org.simplextensions.ui.menu.scanner;

import javassist.bytecode.annotation.Annotation;
import org.simplextensions.annotations.ExtensionStyle;
import org.simplextensions.registry.*;
import org.simplextensions.scanner.ClassScannerHelper;
import org.simplextensions.ui.menu.IAction;
import org.simplextensions.ui.menu.MenuExtensionPoint;
import org.simplextensions.ui.menu.MenuExtensionType;
import org.simplextensions.ui.menu.annotations.*;

import static org.simplextensions.ui.menu.MenuExtensionPoint.*;

/*import org.simplextensions.ui.menu.annotations.Actions;*/

public class MenuScannPhaseListener implements ISimpleXtensionsClassScanner {

	public void scanClass(IExtensionRegistry extensionRegistry, SimpleXtensionsBundle bundle, String className, Annotation a) {
		if (a.getTypeName().equals(Action.class.getCanonicalName())) {
			scanAction(extensionRegistry, bundle, className, a);
		} else if (a.getTypeName().equals(Menus.class.getCanonicalName())) {
			scanMenus(extensionRegistry, bundle, className, a);
		} else if (a.getTypeName().equals(Menu.class.getCanonicalName())) {
			scanMenu(extensionRegistry, bundle, className, a);
		} /*
		 * else if (a.getTypeName().equals(Actions.class.getCanonicalName())) {
		 * scanActions(extensionRegistry, bundle, className, a); }
		 */else if (a.getTypeName().equals(Separator.class.getCanonicalName())) {
			scanSeparator(extensionRegistry, bundle, className, a);
		} else if (a.getTypeName().equals(Separators.class.getCanonicalName())) {
			scanSeparators(extensionRegistry, bundle, className, a);
		}
	}

	private void scanSeparator(IExtensionRegistry extensionRegistry, SimpleXtensionsBundle bundle, String className, Annotation a) {
		String id = "Separator" + extensionRegistry.getSequenceValue(Separator.class.getCanonicalName());
		String parent = ClassScannerHelper.getStringValue(a, PARENT);
		Integer order = ClassScannerHelper.getIntegerValue(a, ORDER);

		Extension extension = new Extension(extensionRegistry, bundle, className, id, ExtensionStyle.VIRTUAL, null);
		extension.setPropertyValue(PARENT, new PropertyValue(parent));
		extension.setPropertyValue(TYPE, new PropertyValue(MenuExtensionType.Separator.ordinal()));
		extension.setPropertyValue(ORDER, new PropertyValue(order));
		extensionRegistry.addExtension(extension, MenuExtensionPoint.ID);
	}

	private void scanSeparators(IExtensionRegistry extensionRegistry, SimpleXtensionsBundle bundle, String className, Annotation a) {

		Annotation[] annotationsValue = ClassScannerHelper.getAnnotationsValue(a, "value");
		for (Annotation a2 : annotationsValue) {
			scanSeparator(extensionRegistry, bundle, className, a2);
		}
	}

	private void scanMenu(IExtensionRegistry extensionRegistry, SimpleXtensionsBundle bundle, String className, Annotation a) {
		String id = ClassScannerHelper.getStringValue(a, "id");
		String parent = ClassScannerHelper.getStringValue(a, PARENT);
		Integer order = ClassScannerHelper.getIntegerValue(a, ORDER);

		Extension extension = new Extension(extensionRegistry, bundle, className, id);
		extension.setPropertyValue(PARENT, new PropertyValue(parent));
		extension.setPropertyValue(TYPE, new PropertyValue(MenuExtensionType.Menu.ordinal()));
		extension.setPropertyValue(ORDER, new PropertyValue(order));
		extensionRegistry.addExtension(extension, MenuExtensionPoint.ID);
	}

	private void scanMenus(IExtensionRegistry extensionRegistry, SimpleXtensionsBundle bundle, String className, Annotation a) {

		Annotation[] annotationsValue = ClassScannerHelper.getAnnotationsValue(a, "value");
		for (Annotation a2 : annotationsValue) {
			scanMenu(extensionRegistry, bundle, className, a2);
		}
	}

	/*
	 * private void scanActions(IExtensionRegistry extensionRegistry, Bundle
	 * bundle, String className, Annotation a) {
	 * 
	 * Annotation[] annotationsValue = ScannHelper.getAnnotationsValue(a,
	 * "value"); for (Annotation a2 : annotationsValue) {
	 * scanAction(extensionRegistry, bundle, className, a2); } }
	 */

	private void scanAction(IExtensionRegistry extensionRegistry, SimpleXtensionsBundle bundle, String className, Annotation a) {

		String id = ClassScannerHelper.getStringValue(a, "id");
		if ("".equals(id))
			id = "Action"+extensionRegistry.getSequenceValue(IAction.class.getCanonicalName());
		
		String parent = ClassScannerHelper.getStringValue(a, PARENT);
		String image = ClassScannerHelper.getStringValue(a, IMAGE);
		Integer order = ClassScannerHelper.getIntegerValue(a, ORDER);

		Extension extension = new Extension(extensionRegistry,bundle, className, id);
		extension.setPropertyValue(PARENT, new PropertyValue(parent));
		extension.setPropertyValue(IMAGE, new PropertyValue(image));
		extension.setPropertyValue(TYPE, new PropertyValue(MenuExtensionType.Action.ordinal()));
		extension.setPropertyValue(ORDER, new PropertyValue(order));
		extensionRegistry.addExtension(extension, MenuExtensionPoint.ID);

	}
}
