package org.simplextensions.ui.preferences;

import org.simplextensions.registry.IServiceRegistry;
import org.simplextensions.ui.preferences.xml.XMLPreferencesPersister;

/**
 * {@link IPreferencesPersister} is used as factory of {@link IPreferences}. It
 * creates isntances of {@link IPreferences} and stores to persistent storage.
 * if is used by {@link PreferencesService}.
 * 
 * 
 * @see {@link IPreferences}, {@link PreferencesService},
 *      {@link XMLPreferencesPersister}
 * 
 * 
 * @author krzyzak
 * 
 */
public interface IPreferencesPersister {

	/**
	 * initialize persister
	 * 
	 * @param serviceRegistry
	 */
	void init(IServiceRegistry serviceRegistry);

	/**
	 * finds ipreferences in persistent storage identified by given id
	 * associated with given bundle. if no such preferences are found empty
	 * instance is created.
	 * 
	 * @param id
	 * @return
	 */
	IPreferences get(String id, String bundleId);

	/**
	 * saves to persistent storage given preferences
	 * 
	 * @param preferences
	 */
	void save(IPreferences preferences);

}
