package org.simplextensions.ui.settings;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * 
 * 
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 24-05-2010 21:18:47
 */
public class SettingsEditorMetaData {

	private final ISettingsEditor<?> editor;

	private SettingsEditorMetaData parent;
	private List<SettingsEditorMetaData> children = new LinkedList<SettingsEditorMetaData>();

	public SettingsEditorMetaData(ISettingsEditor<?> editor) {
		this(null, editor);
	}

	public SettingsEditorMetaData(SettingsEditorMetaData parent, ISettingsEditor<?> editor) {
		this.parent = parent;
		if (parent != null) {
			parent.addChild(this);
		}
		this.editor = editor;
	}

	private void addChild(SettingsEditorMetaData settingsEditorMetaData) {
		if (!children.contains(settingsEditorMetaData))
			children.add(settingsEditorMetaData);
	}

	public SettingsEditorMetaData getParent() {
		return this.parent;
	}

	public List<SettingsEditorMetaData> getChildren() {
		return Collections.unmodifiableList(children);
	}

	public ISettingsEditor<?> getEditor() {
		return editor;
	}

	void dispose() {
		if (this.parent != null) {
			this.parent.children.remove(this);
			this.parent = null;
		}
	}

	public String toString() {
		return this.editor.getName();
	}

}
