package org.simplextensions.ui.view;

import org.simplextensions.registry.Extension;
import org.simplextensions.registry.ExtensionPointAdapter;
import org.simplextensions.registry.IExtensionPoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

@org.simplextensions.annotations.ExtensionPoint(id = ViewExtensionPoint.ID, extensionClass = { IView.class })
public class ViewExtensionPoint extends ExtensionPointAdapter implements IExtensionPoint {

	public static final String ID = "ViewExtensionPoint";

	private Collection<Extension> extensions = new LinkedList<Extension>();

	public void addExtension(Extension extension) {
		if (!extensions.contains(extension))
			extensions.add(extension);
	}

	public Collection<IView<?>> getViews() {
		Collection<IView<?>> result = new ArrayList<IView<?>>(extensions.size());

		for (Extension e : extensions) {
			result.add((IView<?>) getExtensionRegistry().createExecutable(e));
		}

		return result;
	}

}
