package org.simplextensions;

import java.io.IOException;
import java.util.Collection;
import java.util.List;

import org.simplextensions.configuration.BundleConfiguration;
import org.simplextensions.configuration.ConfigurationReader;
import org.simplextensions.registry.ExtensionRegistry;
import org.simplextensions.registry.ExtensionRegistryServiceAdapter;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.registry.IService;
import org.simplextensions.registry.IServiceRegistry;

/**
 * @author Tomasz Krzyak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-08-12 23:37:37
 * 
 */
public class Simplextensions {

	private static Simplextensions instance;

	private Simplextensions() {
	}

	public static synchronized Simplextensions getInstance() {
		if (instance == null) {
			instance = new Simplextensions();
		}
		return instance;
	}

	private IExtensionRegistry defaultServiceRegistry;

	public synchronized IExtensionRegistry getDefault() {
		if (defaultServiceRegistry == null) {
			try {
				defaultServiceRegistry = createExtensionRegistry(getBundleList());
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
		return defaultServiceRegistry;
	}

	public List<BundleConfiguration> getBundleList() throws IOException {
		return ConfigurationReader.getBundleList();
	}

	public synchronized IExtensionRegistry createNewRegistry() {
		try {
			return createExtensionRegistry(getBundleList());
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * creates new instance of serviceRegistry, extensionRegistry and links them
	 * together (serviceregistry as extension of extensionregistry and
	 * extensionregistry as service of serviceregistry)
	 * 
	 * @return
	 * @throws Exception
	 */
	public IExtensionRegistry createExtensionRegistry(Collection<BundleConfiguration> bundles) throws Exception {

		ExtensionRegistry extensionRegistry = new ExtensionRegistry(bundles);
		extensionRegistry.start();

		IServiceRegistry sr = (IServiceRegistry) extensionRegistry.getExtensionPoint(IService.EP_ID).getExecutable();
		sr.start();

		sr.registerService(IExtensionRegistry.class, new ExtensionRegistryServiceAdapter(extensionRegistry));

		return extensionRegistry;
	}

}
