/**
 * 
 */
package org.simplextensions.registry;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.simplextensions.annotations.ExtensionStyle;

/**
 * @author Tomasz Krzyak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-07-30 22:35:47
 * 
 */
public class ExtensionPoint extends ConfigurableElem {

	private Set<Class<?>> defaultExtensionClasses = new HashSet<Class<?>>();

	private Set<IExtensionValidator> validators = new HashSet<IExtensionValidator>();

	/*public ExtensionPoint(IExtensionRegistry extensionRegistry, Bundle bundle, String clazz) {
		super(extensionRegistry, bundle, clazz);
	}*/

	public ExtensionPoint(IExtensionRegistry extensionRegistry, Bundle bundle, IExtensionPoint executable, String id) {
		super(extensionRegistry, bundle, executable, id);
	}

	/*public ExtensionPoint(IExtensionRegistry extensionRegistry, Bundle bundle, String clazz, String id) {
		this(extensionRegistry, bundle, clazz, id, null);
	}*/

	/*public ExtensionPoint(IExtensionRegistry extensionRegistry, Bundle bundle, String clazz, String id, Class<?>[] defaultExtensionClasses) {
		this(extensionRegistry, bundle, clazz, id, defaultExtensionClasses, ExtensionStyle.PROTOTYPE, null);
	}*/

	public ExtensionPoint(IExtensionRegistry extensionRegistry, Bundle bundle, String clazz, String id, Class<?> defaultExtensionClasses[],
			ExtensionStyle extensionStyle, String factoryMethod) {
		super(extensionRegistry, bundle, clazz, id, extensionStyle, factoryMethod);
		this.defaultExtensionClasses.addAll(Arrays.asList(defaultExtensionClasses));
	}

	/**
	 * @return the extensionClass
	 */
	public Set<Class<?>> getDefaultExtensionClasses() {
		return Collections.unmodifiableSet(defaultExtensionClasses);
	}

/*	public Collection<Extension> getExtensions() {
		return super.getExtensionRegistry().getExtensions(getId());
	}
*/
	public Collection<Extension> getActiveExtensions() {
		return getExtensionRegistry().getActiveExtensions(this);
	}

	public void addValidator(IExtensionValidator validator) {
		this.validators.add(validator);
	}

	public void removeValidator(IExtensionValidator validator) {
		this.validators.remove(validator);
	}

	public Collection<IExtensionValidator> getVaidators() {
		return Collections.unmodifiableCollection(this.validators);
	}

	public synchronized IExtensionPoint getExecutable() {
		if (executable == null) {
			executable = super.getExecutable();
			((IExtensionPoint)executable).initialize(this);
		}
		return (IExtensionPoint) this.executable;
	}
}
