package org.simplextensions.registry;

import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;

import org.simplextensions.scanner.IScanPhaseListener;

public class ScanPhaseListenerAdapter implements IScanPhaseListener {

	private final IExtensionScanPhaseListener extensionScanPhaseListener;
	private final IExtensionRegistry registry;
	private final Bundle bundle;

	public ScanPhaseListenerAdapter(IExtensionRegistry registry, Bundle bundle,
			IExtensionScanPhaseListener extensionScanPhaseListener) {
		this.registry = registry;
		this.bundle = bundle;
		this.extensionScanPhaseListener = extensionScanPhaseListener;
	}

	public void scanClass(ClassFile classFile, Annotation a) {
		extensionScanPhaseListener.scanClass(registry, bundle, classFile
				.getName(), a);
	}

	public boolean equals(Object o) {
		if (o instanceof ScanPhaseListenerAdapter) {
			return this.extensionScanPhaseListener
					.equals(((ScanPhaseListenerAdapter) o).extensionScanPhaseListener);
		}
		return false;
	}

}