package org.simplextensions.registry.phaselisteners;

import javassist.bytecode.annotation.Annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.simplextensions.annotations.ExtensionStyle;
import org.simplextensions.registry.Bundle;
import org.simplextensions.registry.EScanPhaseListener;
import org.simplextensions.registry.Extension;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.scanner.ScannHelper;

public class ExtensionScanPhaseListener extends EScanPhaseListener {

	private final static Log log = LogFactory.getLog(ExtensionScanPhaseListener.class);

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.simplextensions.core.scanner.IScanPhaseListener#scanClass(java
	 * .lang.Class, javassist.bytecode.annotation.Annotation)
	 */
	public void scanClass(IExtensionRegistry extensionRegistry, Bundle bundle, String className, Annotation a) {
		log.trace("scanning extension's class: " + className);

		String substring = className.substring(className.lastIndexOf(".") + 1);

		String smvId = ScannHelper.getStringValue(a, "id", substring + getSequenceValue(substring));
		String smvPointId = ScannHelper.getStringValue(a, "pointId", null);
		String smvFM = ScannHelper.getStringValue(a, "factoryMethod");
		ExtensionStyle emvStyle = (ExtensionStyle) ScannHelper.getEnumValue(a, "style");

		/*if (smvPointId==null || "".equals(smvPointId)) {
			log.warn("Ommiting class: "+classFile.getName()+". It does not declare extension point id.");
			return;
		}*/
			
			Extension extension = new Extension(extensionRegistry, bundle, className, smvId, smvPointId, emvStyle, smvFM);
			extensionRegistry.addExtension(extension);
	}

}