package org.simplextensions.registry;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.Simplextensions;

import static junit.framework.TestCase.*;

@RunWith(MockitoJUnitRunner.class)
public class ExtensionRegistryTest {

	@Test
	public void testScan() {
		IExtensionRegistry default1 = Simplextensions.getInstance().createNewRegistry();
		IServiceRegistry serviceRegistry = (IServiceRegistry) default1.getExtensionPoint(IService.EP_ID).getExecutable();

		assertNotNull(serviceRegistry);
	}

	@Test
	public void testExtensionServiceRegistriesTies() {
		IExtensionRegistry default1 = Simplextensions.getInstance().createNewRegistry();
		IServiceRegistry serviceRegistry = (IServiceRegistry) default1.getExtensionPoint(IService.EP_ID).getExecutable();

		assertNotNull(serviceRegistry);
		assertNotNull(serviceRegistry.getService(IExtensionRegistry.class));
	}

}
