package org.simplextensions.ui.menu;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import org.simplextensions.ui.view.ISwingViewRegion;
import org.simplextensions.ui.view.IView;

public class ViewMenuManager extends MenuManager {

	private MenuExtensionPoint mep;
	private final String menuId;
	private final IView<ISwingViewRegion> view;
	private JMenu jMenu;

	public ViewMenuManager(IView<ISwingViewRegion> view, String menuId) {
		this.view = view;
		this.menuId = menuId;
		this.mep = view.getMenuExtensionPoint();
	}

	public JMenu getMenu() {
		if (jMenu == null)
			jMenu = createMenu(mep.getMenu(menuId));
		return jMenu;
	}

	protected JMenuItem createMenuItems(MenuExtensionMetadata submemd, JMenu parentMenu, IActions executable) {
		if (executable instanceof IViewActions) {
			((IViewActions) executable).init(view);
		}
		return super.createMenuItems(submemd, parentMenu, executable);
	}

	protected JMenuItem createMenuItem(final MenuExtensionMetadata submemd, final IAction executable) {
		if (executable instanceof IViewAction) {
			((IViewAction) executable).init(view);
		}
		return super.createMenuItem(submemd, executable);
	}

}