package org.simplextensions.ui.view;

import javax.swing.JPanel;

import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.ui.menu.MenuExtensionPoint;

public class SwingViewRegion implements ISwingViewRegion {

	private final JPanel panel;
	private final IExtensionRegistry extensionRegistry;

	public SwingViewRegion(IExtensionRegistry extensionRegistry, JPanel jPanel) {
		this.extensionRegistry = extensionRegistry;
		this.panel = jPanel;
	}

	public JPanel getParentPanel() {
		return panel;
	}

	public IExtensionRegistry getExtensionRegistry() {
		return this.extensionRegistry;
	}

	public MenuExtensionPoint getMenuExtensionPoint() {
		return (MenuExtensionPoint) this.extensionRegistry.getExtensionPoint(MenuExtensionPoint.ID).getExecutable();
	}

}
