package org.simplextensions.ui;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simplextensions.Simplextensions;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.ui.ApplicationWindow;
import org.simplextensions.ui.menu.WindowMenuManager;

/**
 * 
 * 
 * @author Tomasz Krzyak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-05-17 10:11:47
 */
public class SWTApplicationWindow extends ApplicationWindow {

	private final WindowMenuManager windowMenuManager;

	private final Shell shell;

	private Display display;

	public SWTApplicationWindow() {
		this(Simplextensions.getInstance().getDefault());
	}

	public SWTApplicationWindow(IExtensionRegistry extensionRegistry) {
		super(extensionRegistry);
		this.shell = createShell();
		this.display = this.shell.getDisplay();
		this.windowMenuManager = new WindowMenuManager(this, "mainMenu");
	}

	public WindowMenuManager getWindowMenuManager() {
		return windowMenuManager;
	}

	protected Shell createShell() {
		return new Shell(new Display());
	}

	public Shell getShell() {
		return this.shell;
	}

	public void open() {
		shell.open();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}

}
