package org.simplextensions.ui.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.simplextensions.ui.IApplicationWindow;
import org.simplextensions.ui.SWTApplicationWindow;

/**
 * 
 * 
 * @author Tomasz Krzyak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-05-17 10:11:43
 */
public class WindowMenuManager extends MenuManager {

	private final IApplicationWindow applicationWindow;
	private final String menuId;
	private MenuExtensionPoint mep;
	private final Shell shell;

	public WindowMenuManager(IApplicationWindow applicationWindow, Shell shell, String menuId) {
		this.applicationWindow = applicationWindow;
		this.shell = shell;
		this.menuId = menuId;
		mep = applicationWindow.getMenuExtensionPoint();
	}

	public WindowMenuManager(SWTApplicationWindow applicationWindow, String menuId) {
		this.applicationWindow = applicationWindow;
		this.shell = applicationWindow.getShell();
		this.menuId = menuId;
		mep = applicationWindow.getMenuExtensionPoint();

		this.shell.setMenuBar(getMenuBar(this.shell));
	}

	public IApplicationWindow getApplicationWindow() {
		return applicationWindow;
	}

	public Menu getMenuBar(Shell shell) {
		MenuExtensionMetadata menu = mep.getMenu(menuId);
		Menu menuBar = new Menu(shell, SWT.BAR);

		for (MenuExtensionMetadata memd : menu.getSubItems()) {
			createSubMenu(menuBar, memd);
		}
		return menuBar;
	}

	protected void createMenuItems(Menu parentMenu, MenuExtensionMetadata submemd, IActions executable) {
		if (executable instanceof IApplicationWindowActions) {
			((IApplicationWindowActions) executable).init(applicationWindow);
		}
		
		super.createMenuItems(parentMenu, submemd, executable);
	}

	protected void createMenuItem(Menu parentMenu, MenuExtensionMetadata submemd, IAction executable) {
		if (executable instanceof IApplicationWindowAction) {
			((IApplicationWindowAction) executable).init(applicationWindow);
		}
		
		super.createMenuItem(parentMenu, submemd, executable);
	}

}