package org.simplextensions.ui;

/**
 * interface indicating that implementing class holds state and that interested
 * classes can listen to changes of that state
 * 
 * @author Tomasz Krzyak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-05-10 09:47:48
 */
public interface IStatefulControl {

	/**
	 * adds state change listener
	 * 
	 * @param stateListener
	 *            listener
	 */
	void addStateChangeListener(IStateListener stateListener);

	/**
	 * removes state change listener
	 * 
	 * @param stateListener
	 *            listener
	 */
	void removeStateChangeListener(IStateListener stateListener);

}
