package org.simplextensions.ui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.simplextensions.annotations.Extension;
import org.simplextensions.annotations.Properties;
import org.simplextensions.annotations.Property;
import org.simplextensions.registry.AService;
import org.simplextensions.registry.IService;
import org.simplextensions.ui.properties.PropertiesReader;

/**
 * Service that find simplextensions-ui.properties files and reads properties.
 * it uses {@link PropertiesReader} to find every simplextensions-ui.properties
 * file and merge values.
 * 
 * @see {@link PropertiesReader}
 * 
 * @author krzyzak
 * 
 */
@Extension
@Properties( { @Property(name = IService.SERVICE_INTERFACE, classValue = ISimpleXtensionsUIService.class) })
public class SimpleXtensionsUIService extends AService implements ISimpleXtensionsUIService {

	private static final Log log = LogFactory.getLog(SimpleXtensionsUIService.class);

	public final String PropertiesFileName = "simplextensions-ui.properties";

	private PropertiesReader propertiesReader;

	public SimpleXtensionsUIService() {

	}

	public SimpleXtensionsUIService(PropertiesReader propertiesReader) {
		this.propertiesReader = propertiesReader;
	}

	public void start() {
		log.info("Starting " + getClass().getSimpleName());
		if (propertiesReader == null)
			propertiesReader = new PropertiesReader("simplextensions-ui.properties");

		super.start();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.simplextensions.ui.ISimpleXtensionsUIService#getProperty(java.lang
	 * .String)
	 */
	public String getProperty(String key) {
		String property = propertiesReader.getProperty(key);
		return property == null || "".equals(property) ? null : property;
	}

}
