package org.simplextensions.ui.menu;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.simplextensions.ui.IApplicationWindow;

/**
 * 
 * 
 * @author Tomasz Krzyak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-05-10 09:57:27
 */
public abstract class MenuExtensionAdapter implements IMenuExtension {

	private IApplicationWindow applicationWindow;

	public String getLabel(MenuExtensionMetadata menuMetadata) {
		ResourceBundle bundle = ResourceBundle.getBundle(getClass().getPackage().getName() + ".messages");

		String key = menuMetadata.getId().replace("/", ".");
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return "!" + key + "!";
		}
	}

	public void init(IApplicationWindow applicationWindow) {
		this.applicationWindow = applicationWindow;
	}

	public IApplicationWindow getApplicationWindow() {
		return applicationWindow;
	}

	public boolean isEnabled(MenuExtensionMetadata metadata) {
		return true;
	}

}
