package org.simplextensions.ui.menu.scanner;

import static org.simplextensions.ui.menu.MenuExtensionPoint.IMAGE;
import static org.simplextensions.ui.menu.MenuExtensionPoint.ORDER;
import static org.simplextensions.ui.menu.MenuExtensionPoint.PARENT;
import static org.simplextensions.ui.menu.MenuExtensionPoint.TYPE;
import javassist.bytecode.annotation.Annotation;

import org.simplextensions.annotations.ExtensionStyle;
import org.simplextensions.registry.Bundle;
import org.simplextensions.registry.EScanPhaseListener;
import org.simplextensions.registry.Extension;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.registry.PropertyValue;
import org.simplextensions.scanner.ScannHelper;
import org.simplextensions.ui.menu.IAction;
import org.simplextensions.ui.menu.MenuExtensionType;
import org.simplextensions.ui.menu.annotations.Action;
/*import org.simplextensions.ui.menu.annotations.Actions;*/
import org.simplextensions.ui.menu.annotations.Menu;
import org.simplextensions.ui.menu.annotations.Menus;
import org.simplextensions.ui.menu.annotations.Separator;
import org.simplextensions.ui.menu.annotations.Separators;

public class MenuScannPhaseListener extends EScanPhaseListener {

	public void scanClass(IExtensionRegistry extensionRegistry, Bundle bundle, String className, Annotation a) {
		if (a.getTypeName().equals(Action.class.getCanonicalName())) {
			scanAction(extensionRegistry, bundle, className, a);
		} else if (a.getTypeName().equals(Menus.class.getCanonicalName())) {
			scanMenus(extensionRegistry, bundle, className, a);
		} else if (a.getTypeName().equals(Menu.class.getCanonicalName())) {
			scanMenu(extensionRegistry, bundle, className, a);
		} /*
		 * else if (a.getTypeName().equals(Actions.class.getCanonicalName())) {
		 * scanActions(extensionRegistry, bundle, className, a); }
		 */else if (a.getTypeName().equals(Separator.class.getCanonicalName())) {
			scanSeparator(extensionRegistry, bundle, className, a);
		} else if (a.getTypeName().equals(Separators.class.getCanonicalName())) {
			scanSeparators(extensionRegistry, bundle, className, a);
		}
	}

	private void scanSeparator(IExtensionRegistry extensionRegistry, Bundle bundle, String className, Annotation a) {
		String id = "Separator" + getSequenceValue(Separator.class.getCanonicalName());
		String parent = ScannHelper.getStringValue(a, PARENT);
		Integer order = ScannHelper.getIntegerValue(a, ORDER);

		Extension extension = new Extension(extensionRegistry, bundle, className, id, null, ExtensionStyle.VIRTUAL, null);
		extension.setPropertyValue(PARENT, new PropertyValue(parent));
		extension.setPropertyValue(TYPE, new PropertyValue(MenuExtensionType.Separator.ordinal()));
		extension.setPropertyValue(ORDER, new PropertyValue(order));
		extensionRegistry.addExtension(extension);
	}

	private void scanSeparators(IExtensionRegistry extensionRegistry, Bundle bundle, String className, Annotation a) {

		Annotation[] annotationsValue = ScannHelper.getAnnotationsValue(a, "value");
		for (Annotation a2 : annotationsValue) {
			scanSeparator(extensionRegistry, bundle, className, a2);
		}
	}

	private void scanMenu(IExtensionRegistry extensionRegistry, Bundle bundle, String className, Annotation a) {
		String id = ScannHelper.getStringValue(a, "id");
		String parent = ScannHelper.getStringValue(a, PARENT);
		Integer order = ScannHelper.getIntegerValue(a, ORDER);

		Extension extension = new Extension(extensionRegistry, bundle, className, id, null);
		extension.setPropertyValue(PARENT, new PropertyValue(parent));
		extension.setPropertyValue(TYPE, new PropertyValue(MenuExtensionType.Menu.ordinal()));
		extension.setPropertyValue(ORDER, new PropertyValue(order));
		extensionRegistry.addExtension(extension);
	}

	private void scanMenus(IExtensionRegistry extensionRegistry, Bundle bundle, String className, Annotation a) {

		Annotation[] annotationsValue = ScannHelper.getAnnotationsValue(a, "value");
		for (Annotation a2 : annotationsValue) {
			scanMenu(extensionRegistry, bundle, className, a2);
		}
	}

	/*
	 * private void scanActions(IExtensionRegistry extensionRegistry, Bundle
	 * bundle, String className, Annotation a) {
	 * 
	 * Annotation[] annotationsValue = ScannHelper.getAnnotationsValue(a,
	 * "value"); for (Annotation a2 : annotationsValue) {
	 * scanAction(extensionRegistry, bundle, className, a2); } }
	 */

	private void scanAction(IExtensionRegistry extensionRegistry, Bundle bundle, String className, Annotation a) {

		String id = ScannHelper.getStringValue(a, "id");
		if ("".equals(id))
			id = "Action"+getSequenceValue(IAction.class.getCanonicalName());
		
		String parent = ScannHelper.getStringValue(a, PARENT);
		String image = ScannHelper.getStringValue(a, IMAGE);
		Integer order = ScannHelper.getIntegerValue(a, ORDER);

		Extension extension = new Extension(extensionRegistry,bundle, className, id, null);
		extension.setPropertyValue(PARENT, new PropertyValue(parent));
		extension.setPropertyValue(IMAGE, new PropertyValue(image));
		extension.setPropertyValue(TYPE, new PropertyValue(MenuExtensionType.Action.ordinal()));
		extension.setPropertyValue(ORDER, new PropertyValue(order));
		extensionRegistry.addExtension(extension);

	}
}
