package org.simplextensions.ui.view;

import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.ui.AStatefulControl;
import org.simplextensions.ui.menu.MenuExtensionPoint;

public abstract class AView<T extends IViewRegion> extends AStatefulControl implements IView<T> {

	private IExtensionRegistry extensionRegistry;
	private T viewRegion;

	public void setFocus() {
	}

	public void init(T viewRegion) {
		this.extensionRegistry = viewRegion.getExtensionRegistry();
		this.viewRegion = viewRegion;
	}

	public IExtensionRegistry getExtensionRegistry() {
		return this.extensionRegistry;
	}

	public MenuExtensionPoint getMenuExtensionPoint() {
		return (MenuExtensionPoint) this.extensionRegistry.getExtensionPoint(MenuExtensionPoint.ID).getExecutable();
	}

	public T getViewRegion() {
		return viewRegion;
	}

}
