package org.simplextensions.ui.menu;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.simplextensions.registry.Extension;
import org.simplextensions.registry.PropertyValue;

public class ExtensionPropertyMatcher extends BaseMatcher<Extension> {

	private final String propertyName;
	private final Object value;

	public ExtensionPropertyMatcher(String propertyName, Object value) {
		this.propertyName = propertyName;
		this.value = value;
	}

	public void describeTo(Description description) {
		description.appendText("extensionp['" + propertyName + "'].equals("
				+ value.toString() + ")");
	}

	public boolean matches(Object item) {
		Extension e = (Extension) item;
		PropertyValue propertyValue = e.getPropertyValue(propertyName);
		if (propertyValue != null) {
			Object valueByType = propertyValue.getValueByType(this.value
					.getClass());
			return (value == null && value == valueByType)
					|| (value != null && value.equals(valueByType));
		}
		return false;
	}

}
