package org.simplextensions.ui.preferences;

import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.*;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;

import static junit.framework.TestCase.*;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.registry.IServiceRegistry;
import org.simplextensions.ui.ISimpleXtensionsUIService;
import org.simplextensions.ui.SimpleXtensionsUIService;
import org.simplextensions.ui.preferences.IPreferences;
import org.simplextensions.ui.preferences.IPreferencesService;
import org.simplextensions.ui.preferences.PreferencesService;
import org.simplextensions.ui.preferences.xml.XMLPreferencesPersister;
import org.simplextensions.ui.properties.PropertiesReader;

@RunWith(MockitoJUnitRunner.class)
public class PreferencesServiceTest {

	private SimpleXtensionsUIService sxUIService;
	private PreferencesService preferencesService;

	@Before
	public void setUp() {
		System.out.println("---------------------------------------------------------------------");

		PropertiesReader propertiesReader = mock(PropertiesReader.class);
		when(propertiesReader.getProperty(eq(XMLPreferencesPersister.XMLStorageDirProperty))).thenReturn("./preferences/");
		when(propertiesReader.getProperty(eq(PreferencesService.PersisterPropertyName))).thenReturn(
				XMLPreferencesPersister.class.getCanonicalName());

		IServiceRegistry serviceRegistry = mock(IServiceRegistry.class);

		sxUIService = new SimpleXtensionsUIService(propertiesReader);
		preferencesService = new PreferencesService();
		when(serviceRegistry.getService(eq(ISimpleXtensionsUIService.class))).thenReturn(sxUIService);
		when(serviceRegistry.getService(eq(IPreferencesService.class))).thenReturn(preferencesService);

		sxUIService.init(serviceRegistry);
		preferencesService.init(serviceRegistry);

		sxUIService.start();
		preferencesService.start();
	}

	@After
	public void tearDown() throws IOException {
		File file = new File("./preferences/bundleId.xml");
		System.out.println(file.getCanonicalPath());
		file.delete();
		File file2 = new File("./preferences");
		System.out.println(file2.getCanonicalPath());
		file2.delete();
	}

	@Test
	public void testReadProperties() {

		assertEquals("./preferences/", sxUIService.getProperty(XMLPreferencesPersister.XMLStorageDirProperty));
		assertNull(sxUIService.getProperty(PreferencesService.PersisterFactoryPropertyName));

		IPreferences iPreferences = preferencesService.get("id", "bundleId");

		BigDecimal decimal = new BigDecimal("123.456");
		iPreferences.setBigDecimal("decimal", decimal);
		Date date = new Date();
		iPreferences.setDate("date", date);
		Integer integer = new Integer(123);
		iPreferences.setInteger("integer", integer);
		Boolean boolean1 = Boolean.FALSE;
		iPreferences.setBoolean("boolean", boolean1);

		assertNotNull(iPreferences);
		assertEquals("id", iPreferences.getID());
		assertEquals("bundleId", iPreferences.getBundleId());

		preferencesService.save(iPreferences);

		iPreferences = preferencesService.get("id", "bundleId");

		assertEquals(decimal, iPreferences.get("decimal"));
		assertEquals(date, iPreferences.get("date"));
		assertEquals(integer, iPreferences.get("integer"));
		assertEquals(boolean1, iPreferences.get("boolean"));
	}

	@Test
	public void testReadSubProperties() {
		IPreferences iPreferences = preferencesService.get("id", "bundleId");
		IPreferences child = iPreferences.createChild("child");
		child.setString("string", "string");

		preferencesService.save(iPreferences);

		iPreferences = preferencesService.get("id", "bundleId");
		child = iPreferences.getPreferences("child");

		assertNotNull(child);
		assertEquals("string", child.getString("string"));

	}
}
