/**
 * 
 */
package org.simplextensions.registry;

import org.simplextensions.Utils;
import org.simplextensions.annotations.ExtensionStyle;

/**
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-07-30 22:35:37
 * 
 */
public class Extension extends ConfigurableElem {

	private String pointId;

	/*public Extension(IExtensionRegistry extensionRegistry, Bundle bundle,
			String clazz) {
		super(extensionRegistry, bundle, clazz);
	}*/

	public Extension(IExtensionRegistry extensionRegistry, Bundle bundle,
			String clazz, String id, String pointId) {
		super(extensionRegistry, bundle, clazz, id);
		this.pointId = pointId;
	}

	public Extension(IExtensionRegistry extensionRegistry, Bundle bundle,
			String id, String pointId) {
		super(extensionRegistry, bundle, id);
		this.pointId = pointId;
	}

/*	public Extension(IExtensionRegistry extensionRegistry, Bundle bundle,
			Object executable, String id, String pointId) {
		super(extensionRegistry, bundle, executable, id);
		this.pointId = pointId;
	}*/

	/**
	 * @param clazz
	 * @param extensionStyle
	 * @param id
	 */
	public Extension(IExtensionRegistry extensionRegistry, Bundle bundle,
			String clazz, String id, String pointId,
			ExtensionStyle extensionStyle, String factoryMethod) {
		super(extensionRegistry, bundle, clazz, id, extensionStyle,
				factoryMethod);
		this.pointId = pointId;
	}

	/**
	 * @return the pointId
	 */
	public String getPointId() {
		return pointId;
	}

	void setPointId(String pointId) {
		this.pointId = pointId;
	}

	private ExtensionPoint extensionPoint;

	public boolean isRegistered() {
		return extensionPoint != null;
	}

	void setExtensionPoint(ExtensionPoint extensionPoint) {
		this.extensionPoint = extensionPoint;
		this.pointId = extensionPoint.getId();
	}

	public ExtensionPoint getExtensionPoint() {
		return extensionPoint;
	}

	public static final String PATH_DELIMITER = "/";

	public String[] getDepends() {
		if (extensionPoint != null)
			return Utils.merge(super.getDepends(), extensionPoint.getId());
		else
			return Utils.merge(super.getDepends());
	}

	public String getFullId() {
		if (pointId != null)
			return pointId + "/" + super.getId();
		else
			return super.getId();
	}

}
