/**
 * 
 */
package org.simplextensions.registry;

import java.util.Collection;
import java.util.Map;

import org.simplextensions.registry.phaselisteners.ICreationPhaseListener;
import org.simplextensions.registry.phaselisteners.IRegisterPhaseListener;
import org.simplextensions.registry.phaselisteners.IValidationPhaseListener;

/**
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-08-04 10:27:43
 * 
 */
public interface IExtensionRegistry {

	/**
	 * 
	 * @param <T>
	 * @param clazz
	 * @return
	 */
	<T> T getExtensionPoint(Class<T> clazz);

	/**
	 * 
	 * @param <T>
	 * @param clazz
	 * @param id
	 * @return
	 */
	<T> T getExtensionPoint(Class<T> clazz, String id);

	/**
	 * 
	 * @param name
	 * @return
	 */
	Collection<Extension> getExtensionsMDByClass(String name);

	/**
	 * 
	 * @param name
	 * @return
	 */
	Collection<ExtensionPoint> getExtensionPointsMDByClass(String name);

	/**
	 * 
	 * @param extensionPointId
	 * @return
	 */
	ExtensionPoint getExtensionPointMD(String extensionPointId);

	/**
	 * 
	 * @return
	 */
	Collection<ExtensionPoint> getExtensionPointsMD();

	/**
	 * 
	 * @param extensionPointId
	 * @return
	 */
	Collection<Extension> getExtensionsMD(String extensionPointId);

	/**
	 * 
	 * @param extension
	 */
	void addExtension(Extension extension);

	/**
	 * 
	 * @param extensionPoint
	 */
	void addExtensionPoint(ExtensionPoint extensionPoint);

	/**
	 * 
	 * @param extensionPoint
	 * @param extension
	 */
	void registerExtension(ExtensionPoint extensionPoint, Extension extension);

	/**
	 * 
	 * @param configurableElem
	 * @return
	 */
	Object createExecutable(ConfigurableElem configurableElem);

	/**
	 * 
	 * @param extensionPoint
	 * @return
	 */
	Collection<Extension> getActiveExtensions(ExtensionPoint extensionPoint);

	/**
	 * 
	 * @return
	 */
	Collection<? extends ICreationPhaseListener> getCreationListeners();

	/**
	 * 
	 * @return
	 */
	Collection<? extends IValidationPhaseListener> getValidationListeners();

	/**
	 * 
	 * @return
	 */
	Collection<? extends IRegisterPhaseListener> getRegisterListeners();

	/**
	 * 
	 * @return
	 */
	Map<Class<?>, Map<Integer, Collection<IExtensionScanPhaseListener>>> getScanListeners();

	/**
	 * 
	 * @return
	 */
	IServiceRegistry getServiceRegistry();

	<T> T getService(Class<T> clazz);

}
