/**
 * 
 */
package org.simplextensions.registry;

import org.simplextensions.annotations.PropertyType;
import org.simplextensions.registry.exceptions.ExtensionsConfigurationException;
import org.simplextensions.registry.exceptions.ExtensionsValidationException;

/**
 * @author Tomasz Krzyzak, <a href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-07-30 22:36:59
 * 
 */
public class PropertyValidator {

	private boolean reguired;

	private String propertyName;

	private Class<? extends IPropertyValidator> valueValidator;

	private PropertyType propertyType;

	/**
	 * @param reguired
	 *            the reguired to set
	 */
	public void setReguired(boolean reguired) {
		this.reguired = reguired;
	}

	/**
	 * @return the reguired
	 */
	public boolean isReguired() {
		return reguired;
	}

	/**
	 * @param type
	 *            the attributeType to set
	 */
	public void setPropertyType(PropertyType type) {
		this.propertyType = type;
	}

	/**
	 * @return the attributeType
	 */
	public PropertyType getPropertyType() {
		return propertyType;
	}

	/**
	 * @param propertyValue
	 * @return
	 */
	public boolean validate(Extension extension) {
		PropertyValue validatedValue = extension.getPropertyValue(this.propertyName);

		if (this.reguired && validatedValue == null) {
			throw new ExtensionsValidationException("property is reguired");
		}

		
		
		
		IPropertyValidator newInstance = null;
		try {
			newInstance = valueValidator.newInstance();
		} catch (Exception e) {
			throw new ExtensionsConfigurationException(e.getMessage());
		}
		newInstance.validate(extension, validatedValue);
		return true;
	}

	/**
	 * @param propertyValue
	 * 
	 */
	public String getErrorString(PropertyValue propertyValue) {
		return "";
	}

	/**
	 * @param propertyValidatorClass
	 *            the propertyValidatorClass to set
	 */
	public void setValueValidator(Class<? extends IPropertyValidator> propertyValidatorClass) {
		this.valueValidator = propertyValidatorClass;
	}

	/**
	 * @return the propertyValidatorClass
	 */
	public Class<? extends IPropertyValidator> getValueValidator() {
		return valueValidator;
	}

}
