package org.simplextensions.registry.phaselisteners;

import java.util.Collection;

import javassist.bytecode.annotation.Annotation;

import org.simplextensions.Utils;
import org.simplextensions.registry.Bundle;
import org.simplextensions.registry.EScanPhaseListener;
import org.simplextensions.registry.Extension;
import org.simplextensions.registry.ExtensionPoint;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.scanner.ClassScannerHelper;

public class DependenciesScanPhaseListener extends EScanPhaseListener {

	public void scanClass(IExtensionRegistry extensionRegistry, Bundle bundle, String className, Annotation a) {
		String[] smvsFM = ClassScannerHelper.getStringsValue(a, "value");

		Collection<ExtensionPoint> extensionPointsByClass = extensionRegistry.getExtensionPointsMDByClass(className);
		for (ExtensionPoint ep : extensionPointsByClass) {
			ep.setDepends(Utils.merge(ep.getDepends(), smvsFM));
		}
		Collection<Extension> extensionsByClass = extensionRegistry.getExtensionsMDByClass(className);
		for (Extension e : extensionsByClass) {
			e.setDepends(Utils.merge(e.getDepends(), smvsFM));
		}
	}

}
