package org.simplextensions.registry.phaselisteners;

import javassist.bytecode.annotation.Annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.simplextensions.annotations.ExtensionStyle;
import org.simplextensions.registry.Bundle;
import org.simplextensions.registry.EScanPhaseListener;
import org.simplextensions.registry.Extension;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.scanner.ClassScannerHelper;

public class ExtensionScanPhaseListener extends EScanPhaseListener {

	private final static Log log = LogFactory.getLog(ExtensionScanPhaseListener.class);

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.simplextensions.core.scanner.IScanPhaseListener#scanClass(java
	 * .lang.Class, javassist.bytecode.annotation.Annotation)
	 */
	public void scanClass(IExtensionRegistry extensionRegistry, Bundle bundle, String className, Annotation a) {
		log.trace("scanning extension's class: " + className);

		String substring = className.substring(className.lastIndexOf(".") + 1);

		String smvId = ClassScannerHelper.getStringValue(a, "id", substring + getSequenceValue(substring));
		String smvPointId = ClassScannerHelper.getStringValue(a, "pointId", null);
		String smvFM = ClassScannerHelper.getStringValue(a, "factoryMethod");
		ExtensionStyle emvStyle = (ExtensionStyle) ClassScannerHelper.getEnumValue(a, "style");

		Extension extension = new Extension(extensionRegistry, bundle, className, smvId, smvPointId, emvStyle, smvFM);
		extensionRegistry.addExtension(extension);
	}

}