package org.simplextensions.registry.phaselisteners;

import javassist.bytecode.annotation.Annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.simplextensions.registry.Bundle;
import org.simplextensions.registry.EScanPhaseListener;
import org.simplextensions.registry.Extension;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.registry.IService;
import org.simplextensions.registry.PropertyValue;
import org.simplextensions.scanner.ClassScannerHelper;

public class ServiceScanPhaseListener extends EScanPhaseListener {

	private final static Log log = LogFactory.getLog(ServiceScanPhaseListener.class);

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.simplextensions.core.scanner.IScanPhaseListener#scanClass(java
	 * .lang.Class, javassist.bytecode.annotation.Annotation)
	 */
	public void scanClass(IExtensionRegistry extensionRegistry, Bundle bundle, String className, Annotation a) {
		log.trace("scanning service class: " + className);

		Class<?> serviceInterface = ClassScannerHelper.getClassValue(a, "value");
		String extensionId = serviceInterface.getSimpleName() + getSequenceValue(serviceInterface.getSimpleName());

		Extension extension = new Extension(extensionRegistry, bundle, className, extensionId, IService.EP_ID);
		extension.setPropertyValue(IService.SERVICE_INTERFACE, new PropertyValue(serviceInterface));

		extensionRegistry.addExtension(extension);
	}

}