package org.simplextensions.scanner;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

import javassist.bytecode.ClassFile;

public interface IClasspathScannerBundle {

	Iterator<ClassFile> classFileIterator(Set<String> classNamesFilter);

	public abstract class AClassFileIterator implements Iterator<ClassFile> {

		private final Set<String> classNamesFilter = new HashSet<String>();

		private ClassFile next;

		public AClassFileIterator(Set<String> classNamesFilter) {
			this.classNamesFilter.addAll(classNamesFilter);
		}

		public Set<String> getClassNamesFilter() {
			return classNamesFilter;
		}

		public boolean hasNext() {
			return next != null || (next = searchNext()) != null;
		}

		public ClassFile next() {
			if (hasNext()) {
				try {
					return next;
				} finally {
					next = null;
				}
			}
			throw new NoSuchElementException();
		}

		protected abstract ClassFile searchNext();

		public void remove() {
			throw new UnsupportedOperationException("remove not supported");
		}
	}

}
