package org.simplextensions;

import static junit.framework.Assert.assertNotNull;

import java.io.File;
import java.net.URL;
import java.util.Arrays;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.configuration.BundleConfiguration;
import org.simplextensions.configuration.ConfigurationReader;
import org.simplextensions.registry.IExtensionRegistry;

@RunWith(MockitoJUnitRunner.class)
public class SimplExtensionsTest {

	@Test
	public void testGetDefault() throws Exception {

		URL url = Thread.currentThread().getContextClassLoader().getResource("extensions.xml"); // fixed by: Andrzej Zietek

		BundleConfiguration read = ConfigurationReader.read(url);

		IExtensionRegistry default1 = Simplextensions.createExtensionRegistry(Arrays.asList(read));
		assertNotNull(default1.getServiceRegistry());
	}

}
