package org.simplextensions.registry;

import java.util.LinkedList;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.Simplextensions;

import static org.mockito.Mockito.*;
import static junit.framework.TestCase.*;

@RunWith(MockitoJUnitRunner.class)
public class ServiceRegistryTest {

	private ServiceRegistry serviceRegistry;
	private IExtensionRegistry extensionRegistry;

	@Before
	public void setUp() {
		extensionRegistry = Simplextensions.getDefault();
		serviceRegistry = spy(new ServiceRegistry());
		
		when(serviceRegistry.getExtensionRegistry()).thenReturn(extensionRegistry);
	}

	@After
	public void tearDown() {

	}

	@Test
	public void testNotStarterRegistry() {

		IFooService mock = mock(IFooService.class);
		serviceRegistry.registerService(IFooService.class, mock);
		//verify(mock).init(eq(serviceRegistry));
		verifyNoMoreInteractions(mock);

		assertNull(serviceRegistry.getService(IFooService.class));

	}

	@Test
	public void testStarterRegistry() {

		IFooService mock = spy(new FooService());

		serviceRegistry.registerService(IFooService.class, mock);
		//verify(mock).init(eq(serviceRegistry));
		verifyNoMoreInteractions(mock);

		serviceRegistry.start();
		verify(mock).start();
		verify(mock, times(2)).isStarted();
		verifyNoMoreInteractions(mock);

		assertNotNull(serviceRegistry.getService(IFooService.class));
	}

	@Test
	public void testStopServiceRegistry() {

		IFooService mock = mock(IFooService.class);
		when(mock.isStarted()).thenReturn(true);
		serviceRegistry.registerService(IFooService.class, mock);
		serviceRegistry.start();
		assertNotNull(serviceRegistry.getService(IFooService.class));
		reset(mock);

		serviceRegistry.stop();
		verify(mock).stop();

		verifyNoMoreInteractions(mock);
	}

	@Test
	public void testInitialize() {
		FooService fooService = spy(new FooService());
		ExtensionPoint mock = mock(ExtensionPoint.class);
		LinkedList<Extension> activeExtensions = new LinkedList<Extension>();
		Extension e = spy(new Extension(extensionRegistry, new Bundle(extensionRegistry, "TestBundle"),
				FooService.class.getCanonicalName(), "eId", IService.EP_ID));
		e.setValid(true);
		
		e.setPropertyValue(IService.SERVICE_INTERFACE, new PropertyValue(IFooService.class));
		when(e.getExecutable()).thenReturn(fooService);

		activeExtensions.add(e);
		when(mock.getActiveExtensions()).thenReturn(activeExtensions);

		serviceRegistry.initialize(mock);
		verifyNoMoreInteractions(fooService);
		serviceRegistry.start();

		serviceRegistry.getService(IFooService.class);

		//verify(fooService).init(eq(serviceRegistry));
		verify(fooService).start();
		verify(fooService, times(2)).isStarted();

		verifyNoMoreInteractions(fooService);

	}

	public void testServiceLocator() {
		IFooService fooService = mock(IFooService.class);
		IServiceLocator serviceLocator = mock(IServiceLocator.class);
		serviceRegistry.registerServiceLocator(serviceLocator);
		
		verifyNoMoreInteractions(serviceLocator);
		
		serviceRegistry.start();
		
		verify(serviceLocator).start(same(serviceRegistry));
		verifyNoMoreInteractions(serviceLocator);
		
		when(serviceLocator.getService(same(serviceRegistry), eq(IFooService.class))).thenReturn(fooService);
		assertEquals(fooService, serviceRegistry.getService(IFooService.class));
		
		verify(serviceLocator).getService(same(serviceRegistry), eq(IFooService.class));
		verifyNoMoreInteractions(serviceLocator);
	}

}
