package org.simplextensions.registry;

import static junit.framework.Assert.assertEquals;
import static junit.framework.Assert.assertTrue;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.spy;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

import java.util.Collection;
import java.util.LinkedList;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.configuration.BundleConfiguration;
import org.simplextensions.registry.phaselisteners.ExtensionEvent;
import org.simplextensions.registry.phaselisteners.IValidationPhaseListener;
import org.simplextensions.registry.phaselisteners.ValidationPhaseListenerAdapter;

@RunWith(MockitoJUnitRunner.class)
public class ValidationTest {

	@Test
	public void testValidation() {
		ExtensionRegistry er = spy(new ExtensionRegistry(new LinkedList<BundleConfiguration>()));
		er.start();

		Bundle bundle = new Bundle(er, "testBundle");
		IExtensionPoint epe = new IExtensionPoint() {
			public void initialize(ExtensionPoint extensionPoint) {
				extensionPoint.getActiveExtensions();
			}
		};
		ExtensionPoint ep = new ExtensionPoint(er, bundle, epe, "ep_id");
		final Extension invalidExtension = new Extension(er, bundle, "some_invalid_id", "ep_id");
		final Extension validExtension = new Extension(er, bundle, "some_valid_id", "ep_id");

		IValidationPhaseListener listener = spy(new ValidationPhaseListenerAdapter() {
			public void processExtension(ExtensionEvent extensionEvent) {
				if (extensionEvent.getExtension() == invalidExtension) {
					extensionEvent.doit = false;
				} else {
					extensionEvent.doit = true;
				}
			}
		});
		bundle.addValidationPhaseListener(listener);

		er.addExtensionPoint(ep);
		er.addExtension(invalidExtension);
		er.addExtension(validExtension);

		verify(listener, times(3)).processExtension(any(ExtensionEvent.class));
		Collection<Extension> activeExtensions = er.getActiveExtensions(ep);
		assertEquals(1, activeExtensions.size());
		assertTrue(activeExtensions.contains(validExtension));
	}

}
