package org.simplextensions.ui.settings;

import org.simplextensions.di.annotations.Registry;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.ui.menu.ApplicationMenu;
import org.simplextensions.ui.menu.INoContextAction;
import org.simplextensions.ui.menu.MenuExtensionAdapter;
import org.simplextensions.ui.menu.MenuExtensionMetadata;
import org.simplextensions.ui.menu.annotations.Action;

@Action(id = "ShowSettingsAction", parent = ApplicationMenu.WindowMenu)
public class ShowSettingsAction extends MenuExtensionAdapter implements INoContextAction {

	@Registry
	protected IExtensionRegistry extensionRegistry;

	public void run(MenuExtensionMetadata metadata) {
		new SettingsDialog(extensionRegistry).open();
	}

}
