package org.simplextensions.ui.settings.scanner;

import javassist.bytecode.annotation.Annotation;

import org.simplextensions.registry.Bundle;
import org.simplextensions.registry.EScanPhaseListener;
import org.simplextensions.registry.Extension;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.registry.PropertyValue;
import org.simplextensions.scanner.ClassScannerHelper;
import org.simplextensions.ui.settings.SettingsExtensionPoint;

public class SettingsEditorScannPhaseListener extends EScanPhaseListener {

	public void scanClass(IExtensionRegistry extensionRegistry, Bundle bundle, String className, Annotation a) {
		String id = ClassScannerHelper.getStringValue(a, "id");
		String parent = ClassScannerHelper.getStringValue(a, SettingsExtensionPoint.Param_Parent);
		if ("".equals(parent))
			parent = null;

		Extension extension = new Extension(extensionRegistry, bundle, className, id, null);
		extension.setPropertyValue(SettingsExtensionPoint.Param_Parent, new PropertyValue(parent));
		if (parent != null && !"".equals(parent))
			extension.setDepends(new String[] { SettingsExtensionPoint.ID + "/" + parent });
		extensionRegistry.addExtension(extension);
	}

}
