package org.simplextensions.ui.properties;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.properties.ReferencingProperties;

import static junit.framework.TestCase.*;

@RunWith(MockitoJUnitRunner.class)
public class ReferencingPropertiesTest {

	@Before
	public void setUp() {
		System.out.println("---------------------------------------------------------------------");
	}

	@After
	public void tearDown() {

	}

	@Test
	public void testReference() throws IOException {

		String properties = "prop1=1\n" + "prop2=${prop1}";

		ReferencingProperties p = new ReferencingProperties();
		p.load(new ByteArrayInputStream(properties.getBytes()));

		assertEquals("1", p.getProperty("prop2"));

	}

	@Test
	public void testDoubleReference() throws IOException {

		String properties = "prop1=1\n" + "prop2=${prop1}\n" + "prop3=${prop2}";

		ReferencingProperties p = new ReferencingProperties();
		p.load(new ByteArrayInputStream(properties.getBytes()));

		assertEquals("1", p.getProperty("prop3"));

	}

	@Test
	public void testReferenceWithDefaults() throws IOException {

		String defaultProperties = "prop3=1\nprop2=${prop3}";
		ReferencingProperties defaults = new ReferencingProperties();
		defaults.load(new ByteArrayInputStream(defaultProperties.getBytes()));

		String properties = "prop1=${prop2}/${prop3}\n";

		ReferencingProperties p = new ReferencingProperties(defaults);
		p.load(new ByteArrayInputStream(properties.getBytes()));

		assertEquals("1/1", p.getProperty("prop1"));

	}

	@Test
	public void testReferenceWithDefaults2() throws IOException {

		String defaultProperties = "prop3=1\n" + "prop2=${prop3}";
		ReferencingProperties defaults = new ReferencingProperties();
		defaults.load(new ByteArrayInputStream(defaultProperties.getBytes()));

		String properties = "prop1=${prop2}/${prop2}\n";

		ReferencingProperties p = new ReferencingProperties(defaults);
		p.load(new ByteArrayInputStream(properties.getBytes()));

		assertEquals("1/1", p.getProperty("prop1"));

	}

}
