package org.simplextensions.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * simple wrapper class that handles invocations of reflection API regarding
 * Annotations. It is used by Dependency mechanism to extract annotation's
 * properties values. Extracted values are then accessible through
 * getAnnotationValue(String key) method.
 * 
 * 
 * @author Mirek Szajowski
 * 
 */
public class AnnotationInfo {
	private Annotation annotation;

	private Map<String, Object> annotationValues = new HashMap<String, Object>();

	private AnnotationInfo(Annotation annotation) {
		this.annotation = annotation;
		try {
			generateInfoStructure();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

	}

	public static AnnotationInfo generateAnnotationInfo(Annotation annotation) {
		return new AnnotationInfo(annotation);
	}

	private void generateInfoStructure() throws Exception {
		Class<? extends Annotation> annotationType = annotation.annotationType();
		Method[] declaredMethods = annotationType.getDeclaredMethods();
		for (Method method : declaredMethods) {
			if (!method.getDeclaringClass().equals(Annotation.class)) {
				method.setAccessible(true);
				Object value = method.invoke(annotation);
				annotationValues.put(method.getName(), value);
			}
		}
	}

	public Object getAnnotationValue(String key) {
		return annotationValues.get(key);
	}

	public Annotation getAnnotation() {
		return annotation;
	}

}
