package org.simplextensions.ui.menu;

import org.simplextensions.registry.Extension;
import org.simplextensions.registry.IValidationStatus;
import org.simplextensions.registry.ValidationStatus;

/**
 * 
 * 
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-05-10 09:58:13
 */
public class MenuExtensionValidator {

	public IValidationStatus isValid(Extension extension) {
		Integer integerValue = extension.getPropertyValue(MenuExtensionPoint.TYPE).getIntegerValue();
		if (extension.getId() == null)
			return ValidationStatus.failed("Menu extension desn't define property: id");
		if (extension.getPropertyValue(MenuExtensionPoint.ORDER).getIntegerValue() == null)
			return ValidationStatus.failed("Menu extension doesn't define property: order");

		if (integerValue != null) {
			if (integerValue.equals(MenuExtensionType.Action.ordinal())) {
				if (!IAction.class.isAssignableFrom(extension.getClazz()) && !IActions.class.isAssignableFrom(extension.getClazz()))
					return ValidationStatus.failed("Menu extension doesn't implement " + IAction.class.getCanonicalName() + " or "
							+ IActions.class.getCanonicalName());

				if (extension.getPropertyValue(MenuExtensionPoint.PARENT).getStringValue() == null)
					return ValidationStatus.failed("Action menu extension doesn't define property: parent");
			} else {
				if (!IMenuExtension.class.isAssignableFrom(extension.getClazz()))
					return ValidationStatus.failed("Menu extension doesn't implement: " + IMenuExtension.class.getCanonicalName());
				if (integerValue.equals(MenuExtensionType.Menu.ordinal())) {
					return ValidationStatus.ok();
				} else if (integerValue.equals(MenuExtensionType.Separator.ordinal())) {
					if (extension.getPropertyValue(MenuExtensionPoint.PARENT).getStringValue() == null)
						return ValidationStatus.failed("Separator menu extension doesn't define property: parent");
				}
			}
		}
		return ValidationStatus.ok();
	}
}
