package org.simplextensions.ui.menu;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.registry.*;

import java.util.Iterator;

import static junit.framework.Assert.assertEquals;
import static junit.framework.Assert.assertNotNull;

@RunWith(MockitoJUnitRunner.class)
public class MenuExtensionPointTest {

	@Before
	public void setUp() {
		System.out.println("---------------------------------------------------------------------");
	}

	@After
	public void tearDown() {

	}

	@Test
	public void test1Item() throws InstantiationException, IllegalAccessException, ClassNotFoundException {

		ExtensionRegistry mock = new ExtensionRegistry();

		SimpleXtensionsBundle bundle = new SimpleXtensionsBundle(mock, "test");
		Extension parentMenu = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "mainMenu");
		parentMenu.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Menu.ordinal()));
		parentMenu.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(1));

		Extension childAction = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "fileMenu");
		childAction.setPropertyValue(MenuExtensionPoint.PARENT, new PropertyValue("mainMenu"));
		childAction.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Action.ordinal()));
		childAction.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(1));

		MenuExtensionPoint menuExtensionPoint = new MenuExtensionPoint();
		ExtensionPoint extensionPoint = new ExtensionPoint( bundle, menuExtensionPoint, MenuExtensionPoint.ID);

		mock.addExtensionPoint(extensionPoint);
		mock.addExtension(childAction, MenuExtensionPoint.ID);
		mock.addExtension(parentMenu, MenuExtensionPoint.ID);
		
		mock.addBundle(bundle);
		
		menuExtensionPoint = mock.getExtensionPoint(MenuExtensionPoint.class);

		MenuExtensionMetadata menu = menuExtensionPoint.getMenu("mainMenu");

		assertNotNull(menu);
		assertEquals(1, menu.getSubItems().size());
	}

	@Test
	public void test2Items() {

		ExtensionRegistry mock = new ExtensionRegistry();

		SimpleXtensionsBundle bundle = new SimpleXtensionsBundle(mock, "test");
		Extension parentMenu = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "mainMenu");
		parentMenu.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Menu.ordinal()));
		parentMenu.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(1));

		Extension childAction = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "fileAction1");
		childAction.setPropertyValue(MenuExtensionPoint.PARENT, new PropertyValue("mainMenu"));
		childAction.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Action.ordinal()));
		childAction.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(1));

		Extension childAction2 = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "fileAction2");
		childAction2.setPropertyValue(MenuExtensionPoint.PARENT, new PropertyValue("mainMenu"));
		childAction2.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Action.ordinal()));
		childAction2.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(1));

		MenuExtensionPoint menuExtensionPoint = new MenuExtensionPoint();
		ExtensionPoint extensionPoint = new ExtensionPoint( bundle, menuExtensionPoint, MenuExtensionPoint.ID);

		mock.addExtensionPoint(extensionPoint);
		mock.addExtension(childAction2, MenuExtensionPoint.ID);
		mock.addExtension(childAction, MenuExtensionPoint.ID);
		mock.addExtension(parentMenu, MenuExtensionPoint.ID);
		
		menuExtensionPoint = mock.getExtensionPoint(MenuExtensionPoint.class);

		MenuExtensionMetadata menu = menuExtensionPoint.getMenu("mainMenu");

		assertNotNull(menu);
		assertEquals(2, menu.getSubItems().size());
	}

	@Test
	public void test1SubMenu2SubMenuItems() {

		ExtensionRegistry mock = new ExtensionRegistry();

		SimpleXtensionsBundle bundle = new SimpleXtensionsBundle(mock, "test");

		MenuExtensionPoint menuExtensionPoint = new MenuExtensionPoint();
		ExtensionPoint extensionPoint = new ExtensionPoint( bundle, menuExtensionPoint, MenuExtensionPoint.ID);

		Extension rootMenu = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "mainMenu");
		rootMenu.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Menu.ordinal()));
		rootMenu.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(1));

		Extension parentMenu = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "fileMenu");
		parentMenu.setPropertyValue(MenuExtensionPoint.PARENT, new PropertyValue("mainMenu"));
		parentMenu.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Menu.ordinal()));
		parentMenu.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(1));

		Extension childAction = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "fileAction1");
		childAction.setPropertyValue(MenuExtensionPoint.PARENT, new PropertyValue("mainMenu/fileMenu"));
		childAction.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Action.ordinal()));
		childAction.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(1));

		Extension childAction2 = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "fileAction2");
		childAction2.setPropertyValue(MenuExtensionPoint.PARENT, new PropertyValue("mainMenu/fileMenu"));
		childAction2.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Action.ordinal()));
		childAction2.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(1));

		mock.addExtensionPoint(extensionPoint);
		mock.addExtension(childAction2, MenuExtensionPoint.ID);
		mock.addExtension(childAction, MenuExtensionPoint.ID);
		mock.addExtension(parentMenu, MenuExtensionPoint.ID);
		mock.addExtension(rootMenu, MenuExtensionPoint.ID);

		menuExtensionPoint = mock.getExtensionPoint(MenuExtensionPoint.class);
		
		MenuExtensionMetadata menu = menuExtensionPoint.getMenu("mainMenu");

		assertNotNull(menu);
		assertEquals(1, menu.getSubItems().size());
		assertEquals(2, menu.getSubItems().iterator().next().getSubItems().size());
	}

	@Test
	public void testMenusOrder() {

		ExtensionRegistry mock = new ExtensionRegistry();

		SimpleXtensionsBundle bundle = new SimpleXtensionsBundle(mock, "test");
		Extension rootMenu = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "mainMenu");
		rootMenu.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Menu.ordinal()));
		rootMenu.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(1));

		Extension parentMenu = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "fileMenu");
		parentMenu.setPropertyValue(MenuExtensionPoint.PARENT, new PropertyValue("mainMenu"));
		parentMenu.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Menu.ordinal()));
		parentMenu.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(1));

		Extension childAction = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "fileAction1");
		childAction.setPropertyValue(MenuExtensionPoint.PARENT, new PropertyValue("mainMenu/fileMenu"));
		childAction.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Action.ordinal()));
		childAction.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(1));

		Extension childAction2 = new Extension( bundle, MenuExtensionPointTest.class.getCanonicalName(), "fileAction2");
		childAction2.setPropertyValue(MenuExtensionPoint.PARENT, new PropertyValue("mainMenu/fileMenu"));
		childAction2.setPropertyValue(MenuExtensionPoint.TYPE, new PropertyValue(MenuExtensionType.Action.ordinal()));
		childAction2.setPropertyValue(MenuExtensionPoint.ORDER, new PropertyValue(2));

		MenuExtensionPoint menuExtensionPoint = new MenuExtensionPoint();
		ExtensionPoint extensionPoint = new ExtensionPoint( bundle, menuExtensionPoint, MenuExtensionPoint.ID);

		mock.addExtensionPoint(extensionPoint);
		mock.addExtension(childAction2, MenuExtensionPoint.ID);
		mock.addExtension(childAction, MenuExtensionPoint.ID);
		mock.addExtension(parentMenu, MenuExtensionPoint.ID);
		mock.addExtension(rootMenu, MenuExtensionPoint.ID);

		menuExtensionPoint = mock.getExtensionPoint(MenuExtensionPoint.class);
		
		MenuExtensionMetadata menu = menuExtensionPoint.getMenu("mainMenu/fileMenu");

		assertNotNull(menu);
		assertEquals(2, menu.getSubItems().size());

		Iterator<MenuExtensionMetadata> iterator = menu.getSubItems().iterator();
		assertEquals("mainMenu/fileMenu/fileAction1", iterator.next().getId());
		assertEquals("mainMenu/fileMenu/fileAction2", iterator.next().getId());
	}

}
