package org.simplextensions.di;

import java.lang.reflect.Field;

import org.simplextensions.annotations.AnnotationInfo;
import org.simplextensions.annotations.DependencyLocator;
import org.simplextensions.di.annotations.ServiceDependency;
import org.simplextensions.registry.IDependencyLocatorRegistry;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.registry.phaselisteners.IDependencyLocator;

@DependencyLocator(annotations = ServiceDependency.class)
public class DefaultDependencyLocator implements IDependencyLocator {

	private IExtensionRegistry extensionRegistry;

	public DefaultDependencyLocator() {
	}

	public Object getAnnotatedFieldValue(Field field, AnnotationInfo annotationInfo) {
		Class<?> fieldType = field.getType();
		Object service = extensionRegistry.getService(fieldType);
		return service;
	}

	public void init(IDependencyLocatorRegistry locatorRegistry) {
		extensionRegistry = locatorRegistry.getExtensionRegistry();
	}
}
