package org.simplextensions.di;

import static junit.framework.Assert.assertEquals;

import java.lang.annotation.Annotation;

import org.junit.Before;
import org.junit.Test;
import org.simplextensions.annotations.AnnotationInfo;
import org.simplextensions.di.data.AnnotationExample;

@AnnotationExample(name = "fooName", boolValue = true, longValue = 500L)
public class AnnotationInfoTest {
	private AnnotationInfo annotationInfo;

	@Before
	public void setUp() {
		Annotation annotation = AnnotationInfoTest.class.getAnnotation(AnnotationExample.class);
		annotationInfo = AnnotationInfo.generateAnnotationInfo(annotation);
	}

	@Test
	public void getInfoTest() {
		assertEquals("fooName", annotationInfo.getAnnotationValue("name"));
		assertEquals(true, annotationInfo.getAnnotationValue("boolValue"));
		assertEquals(500L, annotationInfo.getAnnotationValue("longValue"));
		assertEquals(0, annotationInfo.getAnnotationValue("intValue"));

	}
}
