package org.simplextensions.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;

/**
 * 
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-07-29 21:57:31
 * 
 */
@Target(ElementType.TYPE)
public @interface ExtensionPoint {

	/**
	 * 
	 * @return
	 */
	String id() default "";

	/**
	 * used to find out to which EP extension should be registered - based on
	 * extension class hierarchy.
	 * 
	 * @return
	 */
	Class<?>[] extensionClass() default {};

	/**
	 * 
	 * @return
	 */
	ExtensionStyle style() default ExtensionStyle.PROTOTYPE;

	/**
	 * 
	 * @return
	 */
	String factoryMethod() default "getInstance";
	
}
