/**
 *
 */
package org.simplextensions.registry;

/**
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-07-30 22:36:12
 */
public class PropertyValue {

    private final String stringValue;
    private final Integer integerValue;
    private final Long longValue;
    private final Boolean boolValue;
    private final Class<?> classValue;

    private final Class[] classValues;

    public PropertyValue(Class[] classes) {
        classValues = classes;
        this.stringValue = null;
        this.boolValue = null;
        this.classValue = null;
        this.integerValue = null;
        this.longValue = null;
    }

    public PropertyValue(Class<?> clazz) {
        this.stringValue = null;
        this.boolValue = null;
        this.classValue = clazz;
        this.integerValue = null;
        this.longValue = null;
        this.classValues = null;
    }

    public PropertyValue(String string) {
        stringValue = string;
        this.boolValue = null;
        this.classValue = null;
        this.integerValue = null;
        this.longValue = null;
        this.classValues = null;
    }

    public PropertyValue(String string, Integer integer, Long l, Boolean b,
                         Class<?> c) {
        stringValue = string;
        integerValue = integer;
        longValue = l;
        boolValue = b;
        classValue = c;
        this.classValues = null;
    }

    public PropertyValue(int typeMenu) {
        integerValue = typeMenu;
        stringValue = null;
        longValue = null;
        boolValue = null;
        classValue = null;
        this.classValues = null;
    }

    /**
     * @return the stringValue
     */
    public String getStringValue() {
        return stringValue;
    }

    /**
     * @return the integerValue
     */
    public Integer getIntegerValue() {
        return integerValue;
    }

    /**
     * @return the longValue
     */
    public Long getLongValue() {
        return longValue;
    }

    /**
     * @return the boolValue
     */
    public Boolean getBoolValue() {
        return boolValue;
    }

    /**
     * @return the classValue
     */
    public Class<?> getClassValue() {
        return classValue;
    }

    public Object getValueByType(Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return getStringValue();
        } else if (clazz.equals(Integer.class)) {
            return getIntegerValue();
        } else if (clazz.equals(Long.class)) {
            return getLongValue();
        } else if (clazz.equals(Boolean.class)) {
            return getBoolValue();
        } else if (clazz.equals(Class.class)) {
            return getClassValue();
        } else
            throw new IllegalArgumentException("unsupported type: "
                    + clazz.getCanonicalName());
    }

}
