package org.simplextensions.scanner;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.registry.exceptions.ExtensionsConfigurationException;

import java.util.Arrays;
import java.util.HashSet;

import static org.mockito.Mockito.*;

@RunWith(MockitoJUnitRunner.class)
public class ACSBTest {

	private ClassScannerBundle csb;
	private ClassFileIterator iterator;

	@Before
	public void setUp() {
		csb = mock(ClassScannerBundle.class);
		iterator = mock(ClassFileIterator.class);
		when(iterator.getCSB()).thenReturn(csb);
		when(iterator.hasNext()).thenCallRealMethod();
		doCallRealMethod().when(iterator).classVisited(anyString());
		when(iterator.getClassNamesFilter()).thenCallRealMethod();
	}

	@Test(expected = ExtensionsConfigurationException.class)
	public void testException() {

		when(csb.getClassNames()).thenReturn(new HashSet<String>(Arrays.asList("org.simplextensions.scanner.ACSBTest")));

		Assert.assertFalse(iterator.hasNext());
		iterator.next();

	}

	@Test
	public void testOK() {

		when(csb.getClassNames()).thenReturn(new HashSet<String>());

		iterator.hasNext();

	}

	@Test
	public void testVisits() {

		when(csb.getClassNames()).thenReturn(new HashSet<String>(Arrays.asList("c1", "c2")));
		Assert.assertEquals(2, iterator.getClassNamesFilter().size());

		iterator.classVisited("c1");
		iterator.classVisited("c2");
		Assert.assertEquals(0, iterator.getClassNamesFilter().size());

	}

}
