package org.simplextensions.ui.menu;

import org.simplextensions.ui.view.ISwingViewRegion;
import org.simplextensions.ui.view.IView;

import javax.swing.*;

public class ViewMenuManager extends MenuManager {

	private final String menuId;
	private final IView<ISwingViewRegion> view;
	private JMenu jMenu;

	public ViewMenuManager(IView<ISwingViewRegion> view, String menuId) {
		super(view.getExtensionRegistry());
		this.view = view;
		this.menuId = menuId;
	}

	public JMenu getMenu() {
		if (jMenu == null)
			jMenu = createMenu(getMep().getMenu(menuId));
		return jMenu;
	}

	protected JMenuItem createMenuItems(MenuExtensionMetadata submemd, JMenu parentMenu, IActions executable) {
		if (executable instanceof IViewActions) {
			((IViewActions) executable).init(view);
		}
		return super.createMenuItems(submemd, parentMenu, executable);
	}

	protected JMenuItem createMenuItem(final MenuExtensionMetadata submemd, final IAction executable) {
		if (executable instanceof IViewAction) {
			((IViewAction) executable).init(view);
		}
		return super.createMenuItem(submemd, executable);
	}

}