package org.simplextensions.ui.menu.scanner;

import javassist.bytecode.annotation.Annotation;
import org.simplextensions.Utils;
import org.simplextensions.annotations.ExtensionStyle;
import org.simplextensions.registry.*;
import org.simplextensions.scanner.ClassScannerHelper;
import org.simplextensions.ui.menu.IAction;
import org.simplextensions.ui.menu.MenuExtensionPoint;
import org.simplextensions.ui.menu.MenuExtensionType;
import org.simplextensions.ui.menu.annotations.*;

import static org.simplextensions.ui.menu.MenuExtensionPoint.*;

/*import org.simplextensions.ui.menu.annotations.Actions;*/

public class MenuScannPhaseListener implements ISimpleXtensionsClassScanner {

	public void scanClass(SimpleXtensionsBundle bundle, String className, Annotation a) {
        if (a.getTypeName().equals(Action.class.getCanonicalName())) {
			scanAction(bundle, className, a);
		} else if (a.getTypeName().equals(Menus.class.getCanonicalName())) {
			scanMenus(bundle, className, a);
		} else if (a.getTypeName().equals(Menu.class.getCanonicalName())) {
			scanMenu(bundle, className, a);
		} /*
		 * else if (a.getTypeName().equals(Actions.class.getCanonicalName())) {
		 * scanActions(extensionRegistry, bundle, className, a); }
		 */else if (a.getTypeName().equals(Separator.class.getCanonicalName())) {
			scanSeparator(bundle, className, a);
		} else if (a.getTypeName().equals(Separators.class.getCanonicalName())) {
			scanSeparators(bundle, className, a);
		}
	}

	private void scanSeparator(SimpleXtensionsBundle bundle, String className, Annotation a) {
		String id = "Separator" + Utils.getSequenceValue(Separator.class.getCanonicalName());
		String parent = ClassScannerHelper.getStringValue(a, PARENT);
		Integer order = ClassScannerHelper.getIntegerValue(a, ORDER);

		Extension extension = new Extension( bundle, className, id, ExtensionStyle.VIRTUAL, null);
		extension.setPropertyValue(PARENT, new PropertyValue(parent));
		extension.setPropertyValue(TYPE, new PropertyValue(MenuExtensionType.Separator.ordinal()));
		extension.setPropertyValue(ORDER, new PropertyValue(order));
		bundle.getExtensionRegistry().addExtension(extension, MenuExtensionPoint.ID);
	}

	private void scanSeparators( SimpleXtensionsBundle bundle, String className, Annotation a) {

		Annotation[] annotationsValue = ClassScannerHelper.getAnnotationsValue(a, "value");
		for (Annotation a2 : annotationsValue) {
			scanSeparator(bundle, className, a2);
		}
	}

	private void scanMenu( SimpleXtensionsBundle bundle, String className, Annotation a) {
		String id = ClassScannerHelper.getStringValue(a, "id");
		String parent = ClassScannerHelper.getStringValue(a, PARENT);
		Integer order = ClassScannerHelper.getIntegerValue(a, ORDER);

		Extension extension = new Extension( bundle, className, id);
		extension.setPropertyValue(PARENT, new PropertyValue(parent));
		extension.setPropertyValue(TYPE, new PropertyValue(MenuExtensionType.Menu.ordinal()));
		extension.setPropertyValue(ORDER, new PropertyValue(order));
		bundle.getExtensionRegistry().addExtension(extension, MenuExtensionPoint.ID);
	}

	private void scanMenus(SimpleXtensionsBundle bundle, String className, Annotation a) {

		Annotation[] annotationsValue = ClassScannerHelper.getAnnotationsValue(a, "value");
		for (Annotation a2 : annotationsValue) {
			scanMenu(bundle, className, a2);
		}
	}

	/*
	 * private void scanActions(IExtensionRegistry extensionRegistry, Bundle
	 * bundle, String className, Annotation a) {
	 * 
	 * Annotation[] annotationsValue = ScannHelper.getAnnotationsValue(a,
	 * "value"); for (Annotation a2 : annotationsValue) {
	 * scanAction(extensionRegistry, bundle, className, a2); } }
	 */

	private void scanAction(SimpleXtensionsBundle bundle, String className, Annotation a) {

		String id = ClassScannerHelper.getStringValue(a, "id");
		if ("".equals(id))
			id = "Action"+Utils.getSequenceValue(IAction.class.getCanonicalName());
		
		String parent = ClassScannerHelper.getStringValue(a, PARENT);
		String image = ClassScannerHelper.getStringValue(a, IMAGE);
		Integer order = ClassScannerHelper.getIntegerValue(a, ORDER);

		Extension extension = new Extension(bundle, className, id);
		extension.setPropertyValue(PARENT, new PropertyValue(parent));
		extension.setPropertyValue(IMAGE, new PropertyValue(image));
		extension.setPropertyValue(TYPE, new PropertyValue(MenuExtensionType.Action.ordinal()));
		extension.setPropertyValue(ORDER, new PropertyValue(order));
		bundle.getExtensionRegistry().addExtension(extension, MenuExtensionPoint.ID);

	}
}
