package org.simplextensions.ui.preferences;

/**
 * Service allowing to persist some parameters used to describe state of an UI
 * Object (Preferences).
 * 
 * @author krzyzak
 * 
 * @see {@link IPreferences}, {@link IPreferencesPersister}
 * 
 */
public interface IPreferencesService {

	/**
	 * finds ipreferences in persistent storage identified by given id
	 * associated with given bundle. if no such preferences are found empty
	 * instance is created.
	 * 
	 * @param id
	 * @return
	 */
	IPreferences get(String id, String bundleId);

	/**
	 * saves to persistent storage given preferences
	 * 
	 * @param preferences
	 */
	void save(IPreferences preferences);
}
