/*
Copyright (c) 2012, Felipe Michels Fontoura, Lucas Longen Gioppo,
Luís Guilherme Bergamini Mendes e Renato Girardi Gasoto.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Universidade Tecnológica Federal do Paraná nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package utfpr.sistemaestagios.dao.text;

import java.io.File;
import java.util.Collection;
import java.util.List;

import jtextdatastore.TextDataCondition;
import jtextdatastore.TextDataTable;
import utfpr.sistemaestagios.dao.DAOCoordenador;
import utfpr.sistemaestagios.types.Coordenador;

/**
 * @author Felipe Michels Fontoura
 */
public class TextDAOCoordenador implements DAOCoordenador {
	private TextDataTable<Coordenador> table;

	public TextDAOCoordenador(File folder) {
		table = new TextDataTable<Coordenador>(Coordenador.class, new File(folder, "coordenador.txt"));
	}

	public Coordenador insert(Coordenador aluno) {
		if (table.insert(aluno)) return aluno;
		else return null;
	}

	public boolean delete(String codigoCurso) {
		Coordenador coordenador = new Coordenador();
		coordenador.codigoCurso = codigoCurso;
		if (table.delete(coordenador)) return true;
		else return false;
	}

	public Coordenador find(String codigoCurso) {
		Coordenador aluno = new Coordenador();
		aluno.codigoCurso = codigoCurso;
		TextDataCondition<Coordenador> condition = table.getMetadata().generatePrimaryKeyMatchesCondition(aluno);
		List<Coordenador> coordenadores = table.select(condition);
		if (coordenadores == null) return null;
		if (coordenadores.size() == 0) return null;
		return coordenadores.get(0);
	}

	public Coordenador update(Coordenador aluno) {
		if (table.update(aluno)) return aluno;
		else return null;
	}

	public Collection<Coordenador> select() {
		return table.select();
	}
}
