package org.test.jpa;

import java.util.List;
import java.util.Random;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import org.test.jpa.model.Department;
import org.test.jpa.model.Employee;
import org.test.jpa.model.Manager;
import org.test.jpa.model.Phone;
import org.test.jpa.model.Project;


public class DataGenerator 
{
	private static final String firstNames[]={
			"James", "John", "Robert", "Michael", "Mary",
			"William", "David", "Richard", "Charles", "Joseph",
			"Thomas", "Patricia", "Christopher", "Linda", "Barbara",
			"Danieal", "Paul", "Mark", "Elizabeth", "Jennifer"			
	};	
	
	private static final String lastNames[]={
			"Smith", "Jonhson", "Williams", "Jones", "Brown", "Davis",
			"Miller", "Wilson", "Moore", "Taylor", "Anderson", "Thomas", 
			"Jackson", "White", "Harris", "Martin", "Thompson", "Garcia",
			"Martinez", "Robinson"			
	};
	
	private static final String departmentName[]={
			"Sales", "Marketing", "Management", "Factory1",
			"Factory2",			
	};
	
	private static final String projectName[]={
			"Big marketing", "Small software", "Refactoring", "GUI Research", "Sales grow",
			"Build new office", "Factory reconstruction","Blue sky","Yellow sub"
	};
	
	private static String getRandomName(String[] names)
	{
		int idx = new Random().nextInt(names.length);
		return names[idx];
	}
	
	private static void generateDepartment(EntityManager em, String name)
	{
		String depName = getRandomName(departmentName);

		em.getTransaction().begin();		

		Department department = new Department();
		department.setName(depName);		
		
		em.persist(department);		
		
	}
	
	public static void generateData(EntityManager em)
	{
		em.getTransaction().begin();
		
		Department department = new Department();
		department.setName("Sales");		
		
		em.persist(department);

		Project project1 = new Project();
		em.persist(project1);

		Project project2 = new Project();
		em.persist(project2);		
		
		Manager manager1 = new Manager();
		manager1.setDepartment(department);
		manager1.setProject(project1);		
		em.persist(manager1);
		
		Manager manager2 = new Manager();	
		manager2.setDepartment(department);
		manager2.setProject(project2);
		em.persist(manager2);
		
		em.getTransaction().commit();
		
		for(int i=0;i<20;i++)
		{
			em.getTransaction().begin();
		
			Phone phone1 = new Phone();
			Phone phone2 = new Phone();
			
			Employee employee = new Employee();
			employee.setFirstName(getRandomName(firstNames));
			employee.setDepartment(department);
			phone1.setNumber("202-09-01");
			phone2.setNumber("200-01-03");
			employee.addPhone(phone1);
			employee.addPhone(phone2);
			employee.addProject(project1);
			employee.addProject(project2);
			
			em.persist(employee);
		
			em.getTransaction().commit();
		}
		
		Query q;
		List<Employee> results;
		Employee emplloyee;

		//Query q = em.createQuery("SELECT e FROM Employee e JOIN e.projects p WHERE p=:project");
		q = em.createNamedQuery("employeeForProject");
		q.setParameter("project", project1);
		q.setFirstResult(0);
		q.setMaxResults(10);
		results = q.getResultList();
		emplloyee = results.get(0);
		Set<Phone> phones = emplloyee.getPhones();
		for(Phone phone :phones)
		{
			String number = phone.getNumber();
		}

		q = em.createNamedQuery("employeeInDepartment");
		q.setParameter("department", department);
		q.setFirstResult(0);
		q.setMaxResults(10);
		results = q.getResultList();
		emplloyee = results.get(0);

		q = em.createNamedQuery("employeeByFullName");
		q.setParameter("firstName", "James");
		q.setFirstResult(0);
		q.setMaxResults(10);
		results = q.getResultList();
		emplloyee = results.get(0);
		
		return;
	}
}
