package org.test.jpa.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.TableGenerator;

@Entity
@Table(name = "phones")
public class Phone 
{
	@TableGenerator(
		     name="phone_Gen",
			 table="ID_GEN",
			 pkColumnName="GEN_NAME",
			 valueColumnName="GEN_VAL")

	@Id
	@GeneratedValue(strategy=GenerationType.TABLE, generator="phone_Gen")
	private long id;	

	private String number;
	
	public String getNumber()
	{
		return number;
	}
	
	public void setNumber(String number)
	{
		this.number = number;
	}
}
