package org.sp.filters;

import java.math.BigDecimal;

import org.sp.model.GPX;

/**
 * Interface defining filter operations. There could be multiple
 * implementations depending on the device type and accuracy. 
 * 
 * @author Peter Lin
 *
 */
public interface Filter {
	public static final BigDecimal EARTH_RADIUS_IN_MILES = new BigDecimal("3963.1676");
	
	Double getBearing();
	Double calculateMph(GPX position1, GPX position2);
	void updateVelocity(GPX gpx);
	void update();
	void predict();
	void estimate();
}
